local t = ...

local InputHandler = function(event)

	----------------------------------------------------------------------------
	-- DEVELOPER & DEBUG STUFF

	-- quick hack to get to the operator menu pressing escape
	if event.type == "InputEventType_FirstPress" and (event.DeviceInput.button == "DeviceButton_escape" or event.GameButton == "Select") then
		SCREENMAN:GetTopScreen():SetNextScreenName("Pause")
		MESSAGEMAN:Broadcast("ScreenshotCurrentScreen")
		t:queuecommand("TransitionScreen")
		return false
	end



	----------------------------------------------------------------------------

	-- if any of these, don't attempt to handle input
	if not event.PlayerNumber or not event.button then
		return false
	end

	-- truncate "PlayerNumber_P1" into "P1"
	local pn = ToEnumShortString(event.PlayerNumber)


	if event.type == "InputEventType_FirstPress" and event.GameButton == "Start" then

		InteractionHandler()

	elseif event.type == "InputEventType_FirstPress" and event.button == "MenuRight" then

		-- handle choices only if dialog is active and choices are available
		if SRT.Dialog.Words and SRT.Dialog.Words[SRT.Dialog.Index].choices and SRT.DialogIsActive then
			SRT.Dialog.ChoiceIndex = ((SRT.Dialog.ChoiceIndex+1) % #SRT.Dialog.Words[SRT.Dialog.Index].choices)
			if SRT.Dialog.ChoiceIndex == 0 then SRT.Dialog.ChoiceIndex = #SRT.Dialog.Words[SRT.Dialog.Index].choices end
			SRT.Dialog.Cursor:queuecommand("UpdateCursor")
			SOUND:PlayOnce(THEME:GetPathS("Common","value"))
		end
	elseif event.type == "InputEventType_FirstPress" and event.button == "MenuLeft" then

		-- handle choices only if dialog is active and choices are available
		if SRT.Dialog.Words and SRT.Dialog.Words[SRT.Dialog.Index].choices and SRT.DialogIsActive then
			SRT.Dialog.ChoiceIndex = ((SRT.Dialog.ChoiceIndex-1) % #SRT.Dialog.Words[SRT.Dialog.Index].choices)
			if SRT.Dialog.ChoiceIndex == 0 then SRT.Dialog.ChoiceIndex = #SRT.Dialog.Words[SRT.Dialog.Index].choices end
			SRT.Dialog.Cursor:queuecommand("UpdateCursor")
			SOUND:PlayOnce(THEME:GetPathS("Common","value"))
		end

	elseif event.type ~= "InputEventType_Release" then

		SRT.Player.input[event.button]	= true

		-- handle player sprite movement
		if event.button == "Up" or event.button == "Down" or event.button == "Left" or event.button == "Right" then

			if event.type == "InputEventType_FirstPress" then
				SRT.Player.input.Active = event.button
			end

			if not SRT.InputIsLocked then
				-- attempt to tween character
				SRT.PlayerSprite:playcommand("AttemptToTween", {dir=event.button})

				-- attempt to tween the map
				t:GetChild("Visuals"):GetChild("Sprite"):playcommand("AttemptToTween")
			end
		end

	elseif event.type == "InputEventType_Release" then
		SRT.Player.input.Active = nil
		SRT.Player.input[event.button]	= false

		-- if a player has released a directional arrow...
		if event.button == "Up" or event.button == "Down" or event.button == "Left" or event.button == "Right" then
			-- ...then attempt to redraw the character sprite in a neutral (standing) state
			SRT.PlayerSprite:queuecommand("AnimationOff")
		end
	end

	return false
end

return InputHandler